<?php 
include './API_Helper/helper.php';
class BiometricAPIS  {

public $base_url = '13.200.119.104:4385/api/v2/WebAPI';
public $apiKey = '011811082431';
public $SerialNumber = 'C26238441B2F2A29';
public $serial_number2 = 'C26910A54F233A29';

public function GetDeviceLogs($con){
  $devicesArray = [$this->SerialNumber,$this->serial_number2];
  foreach($devicesArray as $device){
     $TodayDate = date("Y-m-d");
    $url = $this->base_url.'/GetDeviceLogs/';
   $GetDeviceData = [
     'APIKey'=>$this->apiKey,
     'SerialNumber' => $device,
     'FromDate' => $TodayDate,
     'ToDate' => $TodayDate,
   ];

   $url .= '?'. http_build_query($GetDeviceData);


   $ch = curl_init($url);
   curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
   $response = curl_exec($ch);
   curl_close($ch);
  $DecodeResponse = json_decode($response,true);
//   print_r($DecodeResponse);die;
    //  print_r($DecodeResponse);die;
    if(is_array($DecodeResponse) && !empty($DecodeResponse)){
      foreach($DecodeResponse as $AData){
       createAttendance($con,$AData);
     }
      
   }
  
   }  
//   print_r($DecodeResponse);die;
 
 
}

public function GetLiveUserFromBiometric(){
 $url = $this->base_url.'/FetchLiveUsersFromBiometric/';
 $url .= '?'. http_build_query(['APIKey'=>$this->apiKey,'SerialNumber'=>$this->SerialNumber]);

 $ch = curl_init($url);
 curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
 
 $response  = curl_exec($ch);
 curl_close($ch);
 if(is_array($response) && !empty($response)){
  return $response;
 }
 return false;

     
}

public function UploadUserToDevice($name,$id,$expiry,$SerialNumber){
     $url = $this->base_url.'/UploadUser/';
    $expiry1 = date("Ymd", strtotime($expiry));
 $UserData = [
    'APIKey'=> $this->apiKey,
    'EmployeeName' => $name,
    'EmployeeCode' => $id,
    'CardNumber' => '',
    'SerialNumbers' =>$SerialNumber,
    'VerifyMode' => 1,
    'ToDate' =>$expiry1,
  ];
     
  $url .= '?'. http_build_query($UserData);
  $ch = curl_init($url);
curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
curl_setopt($ch,CURLOPT_POST , true);
curl_setopt($ch,CURLOPT_HTTPHEADER , [
    'Content-Type: application/json'
]);
$response = curl_exec($ch);
 if(curl_errno($ch)){
  echo "cURL Error : - " . curl_error();
  curl_close($ch);
  return false;
 }
curl_close($ch);
// print_r($response);die;

 $this->setUserExpiry($id,$expiry);
  return $response;

}


public function CreateEmployee($con,$data){
   $url = $this->base_url.'/AddEmployee/';

   $CreateEmp = [
      'StaffCode' => $data['uniqueId'],
      'StaffName' => $data['p_name'],
      'Gender' => $data['sex'],
      'Status' => "Working",
      'CompanySName' => "Default",
      'DepartmentSName' => "Default",
      'Location' => "Default",
      'Designation' => "Default",
      'Grade' => "Default",
      'Team' => "Default",
      'DOJ' => $data['date'],
      'DOC' => $data['date'],
      'DOB' => '',
      'DOR' => $data['expiry_date'],
    ];

 

    
  $url .= '?'. http_build_query(['APIKey'=>$this->apiKey]);

  $ch = curl_init($url);
  curl_setopt($ch,CURLOPT_RETURNTRANSFER ,true);
  curl_setopt($ch,CURLOPT_POST,true);
  curl_setopt($ch,CURLOPT_HTTPHEADER , [
   'Content-Type: application/json'
  ]);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($CreateEmp));


  $response  = curl_exec($ch);
  curl_close($ch);
  $this->setUserExpiry($data['uniqueId'],$data['expiry_date']);
 return $response;

}


public function DeleteUserFromBiometric($empCode){
      $devicesArray = [$this->SerialNumber,$this->serial_number2];
     foreach($devicesArray as $device){
         $url = $this->base_url.'/DeleteUser/';
    $DeleteUserRequest = [
    'APIKey' => $this->apiKey,
    'EmployeeCode'=>$empCode,
    'SerialNumbers' => $device,
 ];

 $url .= '?' . http_build_query($DeleteUserRequest);
 $ch = curl_init($url);
 curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
 curl_setopt($ch,CURLOPT_POST,true);
 curl_setopt($ch,CURLOPT_HTTPHEADER , [
    'Content-Type: application/json'
 ]);
 $response = curl_exec($ch);
 curl_close($ch);
  $this->DeleteEmpFromSoftware($empCode);
     }
 

}

public function DeleteEmpFromSoftware($empCode){
  $url = $this->base_url.'/DeleteEmployee/';
  $DeleteEMpRequest = [
     'APIKey' => $this->apiKey,
     'EmployeeCode'=>$empCode,
   ];
 
  $url .= '?' . http_build_query($DeleteEMpRequest);
  $ch = curl_init($url);
  curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
  curl_setopt($ch,CURLOPT_POST,true);
  curl_setopt($ch,CURLOPT_HTTPHEADER , [
     'Content-Type: application/json'
  ]);
  $response = curl_exec($ch);
  curl_close($ch);
  
 }

public function setUserExpiry($empCode,$exp){
     $devicesArray = [$this->SerialNumber,$this->serial_number2];
      foreach($devicesArray as $device){
          $url = $this->base_url.'/SetUserExpiration/';
    $UserRequest = [
    'APIKey' => $this->apiKey,
    'EmployeeCode' => $empCode,
    'SerialNumber' => $device,
    'ExpirationDate' => $exp,
  ];
   $url .= '?'. http_build_query($UserRequest);
  
  $ch = curl_init($url);
  curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
 
    $response = curl_exec($ch);
     curl_close($ch);
      }
      
      
   
 }

public function ClearAllLogs(){

}

public function BlockUserFromBiometric($empCode,$status){
  $devicesArray = [$this->SerialNumber,$this->serial_number2];
  foreach($devicesArray as $device){
    $url = $this->base_url.'/BlockUserinBiometric/';
    $blockUserRequest = [
      'APIKey' => $this->apiKey,
      'EmployeeCode' => $empCode,
      'SerialNumber' => $device,
      'BlockUser' => $status,
    ];
  
    $url .= '?'. http_build_query($blockUserRequest);
    $ch = curl_init($url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
   
    $response = curl_exec($ch);
     curl_close($ch);
   
  }
//   print_r($url);die;

}



public function AddAttendance($con,$data, $SerialNumber){
    
          $data1 = $data;
  $url = $this->base_url.'/AddDeviceLogs/';
  $data['APIKey'] = $this->apiKey;
   $data1['SerialNumber'] = $SerialNumber;
   createAttendance($con, $data1);
      $url .= '?' . http_build_query($data);
     $ch = curl_init($url);
     curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
     $response = curl_exec($ch);
      curl_close($ch);    
  return $response ? true : false;
  
   
  }
 
}




?>